/*
 * ImageTiledCanvas.java - C[Wׂĕ\
 *
 *
 * @author	KatoCo
 * @version
 *
 */

package dicomviewer;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.applet.*;

public class ImageTiledCanvas extends Canvas {

  Viewer    parent;

  Image[]   image;                  // `悷DICOMC[W
  Dimension canvasSize;             // ̃TCY
  int       width, height;          // 摜̃TCY
  int       imgW, imgH;             // 1̉摜̕`TCY
  int       px = 0, py = 0;         // 摜̂̍W\
  int       x0, y0, x1, y1, x2, y2; // }EX̃|CgWi}EXvXAhbOA[Xj
  double    zoom = 1.0;             // gk
  int       zoomW, zoomH;           // 摜̂̕\
  boolean   zoom_flag = false;      // }EXZOOMύX邩ǂH
  boolean   hand = true; 		        // J[\̌`
  boolean   loupe = false;          // [y`悷邩ǂH
  boolean   mouseDown;              // }EXĂԂǂH
  boolean   move = false;           // 摜̕`ʒuړB

  int       tileR, tileC;           // isAj
  int       imageIndex;             // ZbgĂ摜

  int       activeNo = 0;           // ډ摜ԍ
  boolean   changeActive = false;   // ډ摜}EX̃NbNɂĕωH
  int       start =0;               // `悷摜̃X^[gԍ

  // ̕\֘A
  boolean   showStudyInfo = true;   // \邩ǂH
  String[]  patientID;              // (0010,0020)
  String[]  patientName;            // (0010,0010)
  String[]  patientAgeSex;          // (0010,1010) (0010,0040)
  String[]  studyID;                // (0020,0010)
  String[]  studyDate;              // (0008,0020)
  String[]  studyTime;              // (0008,0030)
  String[]  imageNo;                // (0020,0013)
  String[]  ww_wl;                  // ݂WW/WL

  Font      font;                   // \p̃tHg
  FontMetrics fm;                   // FontMetrics

  // RXgN^
  public ImageTiledCanvas(int w, int h, Viewer applet){
    parent = applet;
    zoomH = height = imgH = h;
    zoomW = width  = imgW = w;
    // }EXvXA[X̃Cxgݒ
    addMouseListener(new SetPoint());
    // }EXhbÕCxgݒ
    addMouseMotionListener(new SetPoint_move());
    // tHg̍쐬
    font = new Font("Helvetica", Font.PLAIN, 12);
    fm = getFontMetrics(font);
  }

  // Ȃׂ鐔ݒ肷B
  // ̃\bȟĂяołȂƁA摜addłȂB
  public void setTileType(int r, int c) {
    int max = r * c;

    // ̎擾
    tileR = r;
    tileC = c;
    // ɉĂꎩg̑傫ω
    canvasSize = new Dimension(width * tileC, height * tileR);
    setSize(canvasSize);
    // ɉĕϐ̊m
    image           = new Image[max];
    patientID       = new String[max];
    patientName     = new String[max];
    patientAgeSex   = new String[max];
    studyID         = new String[max];
    studyDate       = new String[max];
    studyTime       = new String[max];
    imageNo         = new String[max];
    ww_wl           = new String[max];
    imageIndex = 0;
  }

  // C[WŌɒǉB
  // łɕ\ł邩\Ăꍇ́A
  // 擪폜ĒǉB
  public void addImage(Image argImage) {
    if(imageIndex < image.length) {
      image[imageIndex] = argImage;
      imageIndex++;
    } else {
      System.arraycopy(image, 1, image, 0, image.length -1);
      image[imageIndex -1] = argImage;
    }
    repaint();
  }

  // C[W擪ɒǉB
  // łɍő吔\Ăꍇ́AŌ폜B
  public void addPreImage(Image argImage) {
    System.arraycopy(image, 0, image, 1, image.length -1);
    image[0] = argImage;
    if(imageIndex < image.length) imageIndex++;
    repaint();
  }

  // C[WindexɃZbgB
  public void setImage(Image argImage, int index) {
    image[index] = argImage;
    imageIndex = index;
    repaint();
  }

  // \邩ȂZbg
  public void setStudyInfo_flag(boolean flag){
    showStudyInfo = flag;
    repaint();
  }

  // indexɃZbg
  public void setStudyInfo(DicomData dicomData, int index) {
    String tag;

    // ̏񂪂ȂNull
    if(dicomData == null) {
      patientID[index] = null;
      patientName[index] = null;
      patientAgeSex[index] = null;
      studyID[index] = null;
      studyDate[index] = null;
      studyTime[index] = null;
      imageNo[index] = null;
      ww_wl[index] = null;

    // 񂪑݂ꍇAꂼ̃^O𒲂ׂĒlZbg
    }else {
      tag = "(0010,0020)";
      if(dicomData.isContain(tag))
        patientID[index] = dicomData.getAnalyzedValue(tag);
      else
        patientID[index] = null;

      tag = "(0010,0010)";
      if(dicomData.isContain(tag))
        patientName[index] = dicomData.getAnalyzedValue(tag);
      else
        patientName[index] = null;

      tag = "(0010,1010)";
      if(dicomData.isContain(tag)) {
        patientAgeSex[index] = dicomData.getAnalyzedValue(tag);
        tag = "(0010,0040)";
        if(dicomData.isContain(tag))
          patientAgeSex[index] += " " + dicomData.getAnalyzedValue(tag);
      }else {
        tag = "(0010,0040)";
        if(dicomData.isContain(tag))
          patientAgeSex[index] = dicomData.getAnalyzedValue(tag);
        else
          patientAgeSex[index] = null;
      }

      tag = "(0020,0010)";
      if(dicomData.isContain(tag))
        studyID[index] = dicomData.getAnalyzedValue(tag);
      else
        studyID[index] = null;

      tag = "(0008,0020)";
      if(dicomData.isContain(tag))
        studyDate[index] = dicomData.getAnalyzedValue(tag);
      else
        studyDate[index] = null;

      tag = "(0008,0030)";
      if(dicomData.isContain(tag))
        studyTime[index] = dicomData.getAnalyzedValue(tag);
      else
        studyTime[index] = null;

      tag = "(0020,0013)";
      if(dicomData.isContain(tag))
        imageNo[index] = dicomData.getAnalyzedValue(tag);
      else
        imageNo[index] = null;
    }
  }

  // \pWW/WL̒lZbg
  public void setWW_WL(int ww, int wl, int index) {
    ww_wl[index] = "" + wl + "/" + ww;
  }

  // indexԂ̃C[WB
  public void changeImage(Image argImage, int index) {
    image[index] = argImage;
    repaint();
  }

  // ډ摜ԍZbg
  public void setActiveNo(int index) {
    this.activeNo = index;
  }

  // ŏɕ\摜̉摜ԍ
  public void setStartNo(int start_imgNo) {
    start = start_imgNo;
  }

  // LoXTCYύX
  public void setCanvasSize(int w, int h) {
    canvasSize = new Dimension(w, h);
    setSize(canvasSize);
    repaint();
  }

  public void paint(Graphics g) {
    update(g);
  }

  public void update(Graphics g)
  {
    // }EXėC[WړB
    // AA͂ȏ㓮Ȃ悤ɂ
    if(px+zoomW > imgW) px = imgW - zoomW;
    if(py+zoomH > imgH) py = imgH - zoomH;
    if(px < 0) px = 0;
    if(py < 0) py = 0;

    // ItXN[̏(摜ꖇALoupep)
    Graphics  offg, loupeg;
    Image     offImage, loupeImage;
    offImage = createImage(width, height);
    offg = offImage.getGraphics();
    loupeImage = createImage(200, 200);
    loupeg = loupeImage.getGraphics();

    int imgNo = 0;
    int tmp_x, tmp_y;

    // C[W`
    for (int j=0; j < tileR; j++) {
      if(imgNo > imageIndex) break;
      for (int i=0; i < tileC; i++) {
        if(imgNo > imageIndex) break;

        // 摜`W߂
        tmp_x = width * i;
        tmp_y = height * j;

        // C[W`
        // ܂A摜1ItXN[ɕ`
        // 摜݂Ȃꍇ
        if(image[imgNo] == null){
          // hԂ
          offg.setColor(Color.black);
          offg.fillRect(0, 0, width, height);
        // 摜݂ꍇ
        }else {
          // 摜(px,py)W畝zoomWAzoomH̃C[W擾ĂāA
          // (0,0)WAItXN[ςɉ摜`
          offg.drawImage(image[imgNo], 0, 0, width, height, px, py, px+zoomW, py+zoomH, this);
        }
        // ItXN[(tmp_x,tmp_y)Wɕ`
        g.drawImage(offImage, tmp_x, tmp_y, this);

        // `
        if(showStudyInfo) {
          int x, y;           // W
          int maxlength = 0;  // ̒

          // ̓O[ŕ`
          g.setColor(Color.green);
          g.setFont(font);
          // 
          x = tmp_x +2;
          y = tmp_y + fm.getAscent() +2;
          if(patientID[imgNo] != null) {
            g.drawString(patientID[imgNo], x, y);
            y += fm.getHeight();
          }
          if(patientName[imgNo] != null) {
            g.drawString(patientName[imgNo], x, y);
            y += fm.getHeight();
          }
          if(patientAgeSex[imgNo] != null) {
            g.drawString(patientAgeSex[imgNo], x, y);
          }
          // 
          y = tmp_y + height - fm.getDescent() -2;
          if(ww_wl[imgNo] != null) {
            g.drawString(ww_wl[imgNo], x, y);
          }
          // E
          // ̒Ƃ̂T
          if(maxlength < fm.stringWidth(studyID[imgNo])) maxlength = fm.stringWidth(studyID[imgNo]);
          if(maxlength < fm.stringWidth(studyDate[imgNo])) maxlength = fm.stringWidth(studyDate[imgNo]);
          if(maxlength < fm.stringWidth(studyTime[imgNo])) maxlength = fm.stringWidth(studyTime[imgNo]);
          x = tmp_x + width - maxlength -2;
          y = tmp_y + fm.getAscent() +2;
          if(studyID[imgNo] != null) {
            g.drawString(studyID[imgNo], x, y);
            y += fm.getHeight();
          }
          if(studyDate[imgNo] != null) {
            g.drawString(studyDate[imgNo], x, y);
            y += fm.getHeight();
          }
          if(studyTime[imgNo] != null) {
            g.drawString(studyTime[imgNo], x, y);
          }
          // E
          x = tmp_x + width - fm.stringWidth(imageNo[imgNo]) -2;
          y = tmp_y + height - fm.getDescent() -2;
          if(imageNo[imgNo] != null) {
            g.drawString(imageNo[imgNo], x, y);
          }
        }

        // C[W̗֊s`
        // I摜ωꍇ
        if(changeActive) {
          // }EX̃NbNW`悷摜̏ꍇ
          if((tmp_x <= x1) && (x1 < tmp_x+width) && (tmp_y <= y1) && (y1 < tmp_y+height))  {
            // 摜݂Ȃꏊ̃NbN̏ꍇ͔giI摜ωȂj
            if(image[imgNo] == null){
              g.setColor(Color.white);
              g.drawRect(tmp_x, tmp_y, width -1, height -1);
            // 摜݂ꍇ́AI摜̉摜ɂāAFg
            }else {
              // activeNo̕ύX
              activeNo = imgNo;
              parent.changeActive(activeNo + start);
              g.setColor(Color.yellow);
              g.drawRect(tmp_x, tmp_y, width -1, height -1);
            }
          // }EX̃NbN̉摜łȂꍇAg
          }else {
            g.setColor(Color.white);
            g.drawRect(tmp_x, tmp_y, width -1, height -1);
          }

        // I摜ωȂꍇ
        }else {
          // I摜Ȃ物Fg
          if(activeNo == imgNo) {
            g.setColor(Color.yellow);
            g.drawRect(tmp_x, tmp_y, width -1, height -1);
          // I摜łȂȂ΁Ag
          }else {
            g.setColor(Color.white);
            g.drawRect(tmp_x, tmp_y, width -1, height -1);
          }
        }
        // [y
        if(loupe && mouseDown) {
          // NbNW`悵Ă摜̏ꍇ[y
          if((tmp_x <= x1) && (x1 < tmp_x+width) && (tmp_y <= y1) && (y1 < tmp_y+height))  {
            // NbNW̑O50sNZvc100sNZ擾A
            // c200sNZ̃ItXN[ɕ`悷i܂A2{ɕ\j
            loupeg.drawImage(offImage, 0, 0, 200, 200, x1-tmp_x-50, y1-tmp_y-50, x1-tmp_x+50, y1-tmp_y+50,this);
          }
        }
        imgNo++;
      }
    } // foȑI

    changeActive = false;

    // [y`
    if(loupe && mouseDown) {
      // NbNW̐^ɂȂ悤Ƀ[yItXN[`
      g.drawImage(loupeImage, x1-100, y1-100, this);
      // [y摜̎ɔg`
      g.setColor(Color.white);
      g.drawRect(x1-100, y1-100, 200, 200);
    }
  }

  // Y[ύX郁\bh
  public void changeZoom(double zoom){
    this.zoom = zoom;
    int zoomW_old = zoomW;
    int zoomH_old = zoomH;
    int px_old = px;
    int py_old = py;

    // Y[̐ݒ
    zoomW = (int)(width * zoom);
    zoomH = (int)(height * zoom);

    // 摜̒S\悤Ɋgk悤ɂ
    px = (int)((zoomW_old - zoomW) >> 1) + px_old;
    py = (int)((zoomH_old - zoomH) >> 1) + py_old;

    repaint();
  }

  // CanvasSizeύX郁\bh
  public void changeCanvasSize(double size) {
    width = (int)(imgW * size);
    height = (int)(imgH * size);
    canvasSize.setSize(width * tileC, height * tileR);
    setSize(canvasSize);
  }

  // Ă鎋_iWjύX
  public void setPxPy(int x, int y) {
    this.px = x;
    this.py = y;
  }

  // Ă鎋_iWj𓾂
  public int getPx() {
    return px;
  }
  public int getPy() {
    return py;
  }

  // [y`悷邩ǂZbg
  public void setLoupeState(boolean state) {
    this.loupe = state;
  }

  // 摜}EXňړ邩ǂZbg
  public void setMoveState(boolean state) {
    this.move = state;
  }

  // 摜}EXŊgk邩ǂZbg
  public void setZoomState(boolean state) {
    this.zoom_flag = state;
  }

  // }EXJ[\̌`ύX郁\bh
  private void changeCursor(){
    if(hand)
    	this.setCursor(new Cursor(Cursor.MOVE_CURSOR));
    else
    	this.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
    hand = !hand;
  }

  // }EX샊Xi[
  class SetPoint extends MouseAdapter {

    // }EXCanvasɓƂ
    public void mouseEntered(MouseEvent e) {
      if(loupe) {
    	  setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));
      }else if(move) {
    	  setCursor(new Cursor(Cursor.HAND_CURSOR));
      }
    }

    // }EXCanvasOɂłƂ
    public void mouseExited(MouseEvent e) {
    	setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
    }

    // }EXƂ̏
    public void mousePressed(MouseEvent e) {
      x0 = x1 = e.getX();
      y0 = y1 = e.getY();
      if(loupe) {
        mouseDown = true;
      }else if(!move) {
        changeCursor(); // J[\̌`ύX
      }
      changeActive = true;
      repaint();
    }

    // }EX𗣂Ƃ̏
    public void mouseReleased(MouseEvent e) {
      x2 = e.getX();
      y2 = e.getY();
      if(loupe) {
        mouseDown = false;
        repaint();
      }else if(move) {
        px = px + x1 - x2;
        py = py + y1 - y2;
        repaint();
      }else if(zoom_flag) {
        changeCursor(); // J[\̌`߂
        parent.drag_changeZoom(y2-y1);
      }else {
        changeCursor(); // J[\̌`߂
        parent.dragDone_changeWwWl(x2-x1, x2-x0, y2-y1, y2-y0);
      }
    }
  }

  class SetPoint_move extends MouseMotionAdapter {

    // }EXhbOꂽƂ
    public void mouseDragged(MouseEvent e) {
      x2 = e.getX();
      y2 = e.getY();
      if(move) {
        px = px + x1 - x2;
        py = py + y1 - y2;
        x1 = x2;
        y1 = y2;
        repaint();

      // Zoom
      }else if(zoom_flag) {
        parent.drag_changeZoom(y2-y1);
        x1 = x2;
        y1 = y2;

      // WW/WL
      }else if(!loupe) {
        parent.drag_changeWwWl(x2-x1, y2-y1);
        x1 = x2;
        y1 = y2;
/*
      // Loupe
      }else {
        x1 = x2;
        y1 = y2;
        repaint();
*/
      }
    }

    public void mouseMoved(MouseEvent e) {
    }
  }
}

