/*
   DynAPI Distribution
   explorer Tree class

   The DynAPI Distribution is distributed under the terms of the GNU LGPL license.

   Requirements:
	dynapi.api [dynlayer, dyndocument, browser, events]
*/

// This object represents a leave in our content tree. Notice that it is not dynlayer-inherited
leave = function(tree,id,icon,icon_sel,url,text,parent) {
	// internal
	this.id = id
	this.tree = tree
	this.icon = icon
	this.icon_sel = icon_sel
	this.url = url
	this.text = text||""
	this.parent = parent
	this.children = []	
	this.count = 0
	// state
	this.open = false
	
	// init
	this.tree.allLeaves[this.id] = this
}
leave.prototype.getHTML = function(level,last,lD) {
	var niv = level||0
	var listaD = lD || new Array()
	var ret = "<tr><td><img src="+leave.white+" height=1 width=5></td><td valign=top>"
	for(var i=0;i<(niv-1);i++) ret += "<img src='"+(listaD[i]?leave.white:leave.line)+"' align=top>"
	if(niv == 0) ret += ""
	else if (this.children.length==0) ret += "<img src='"+(last?leave.noChildrenlast:leave.noChildren)+"' align=top>"
	else {
		if(this.open) ret += "<a href='javascript:"+this.tree+".fold(\""+this.id+"\")'><img border=0 src='"+(last?leave.closelast:leave.close)+"' align=top></a>"
		else ret += "<a href='javascript:"+this.tree+".unfold(\""+this.id+"\")'><img border=0 src='"+(last?leave.openlast:leave.open)+"' align=top></a>"
	}
	
	if(niv!=0) {
		if (this.id == this.tree.currentPos) ret += "<img src='"+(this.icon_sel)+"' align=top>"
		else ret += "<img src='"+(this.icon)+"' align=top>"
	} 
	
	
	ret += "<a class='"+(niv==0 ? leave.style_home: (this.id == this.tree.currentPos ? leave.style_current : leave.style_link)) + "' href='javascript:"+this.tree+".setCurrent(\""+ this.id +"\")'>"
	
	while(this.text.indexOf(" ")>=0) this.text = this.text.replace(" ","&nbsp;")
	if(niv!=0) ret += "&nbsp;"
	ret += this.text+"</a></td><td><img src="+leave.white+" height=1 width=25></td></tr>"

	var q=0
	listaD[niv-1] = last
	if((this.open || niv==0) && this.children.length!=0) {
		for(var i in this.children) { 
			q++;
			ret += this.children[i].getHTML(niv+1,q==this.count,listaD)
			}
	}
	
	return ret
}
leave.prototype.unfoldTo = function(c) {
	this.open = false
	for(var i in this.children) if(this.children[i].unfoldTo(c)) this.open = true
	return this.open || (this.id == c)
}
leave.prototype.toString = function() { return this.id }

// Tree object
explorer = function() {
	this.DynLayer = DynLayer;
	this.DynLayer();
	this.allLeaves = []	
	this.root = new leave(this,this+"Root")
	this.currentPos = 0
	this.currentUrl = ""
	
	this.addEventListener(explorer.cL)
}
// Initialization listener
explorer.cL = new EventListener
explorer.cL.oncreate = function(e) {
	e.getSource().init()
	e.getSource().draw()
}
// Prototypes
explorer.prototype = new DynLayer
explorer.prototype.addLeave = function(id,icon,icon_sel,url,text,parent) {
	new leave(this,id,icon,icon_sel,url,text,(parent&&(parent!="0"))?parent:this.root.toString())
}
explorer.prototype.fold = function(id) {
	this.allLeaves[id].open = false
	this.draw()
}
explorer.prototype.unfold = function(id) {
	this.allLeaves[id].open = true
	this.draw()
}
explorer.prototype.setCurrent = function(id) {
	this.currentPos = id
	this.currentUrl = this.allLeaves[id].url
	this.draw()
	this.invokeEvent("select")
}
explorer.prototype.unfoldTo = function(id) {
	this.allLeaves[this.firstOne].unfoldTo(id)
	this.currentPos = id
}
explorer.prototype.init = function() {
	for(var i in this.allLeaves) {
		var el = this.allLeaves[i]
		var pat = el.parent
		if(pat) {
			this.allLeaves[pat].children[this.allLeaves[pat].children.length] = el
			this.allLeaves[pat].count++
			}
		}
	this.initiated = true
}
explorer.prototype.draw = function() {
	this.setHTML("<table border=0 cellpadding=0 cellspacing=0>"+this.root.getHTML()+"</table>")
	this.setSize(this.getContentWidth(),this.getContentHeight())
}

// Leave setup
leave.line = DynAPI.librarypath+"dynapi/images/explorer/line.gif"
leave.white = DynAPI.librarypath+"dynapi/images/explorer/shim.gif"
leave.open = DynAPI.librarypath+"dynapi/images/explorer/mas_n.gif"
leave.openlast = DynAPI.librarypath+"dynapi/images/explorer/mas_u.gif"
leave.close = DynAPI.librarypath+"dynapi/images/explorer/menos_n.gif"
leave.closelast = DynAPI.librarypath+"dynapi/images/explorer/menos_u.gif"
leave.noChildren = DynAPI.librarypath+"dynapi/images/explorer/nimasnimenos_n.gif"
leave.noChildrenlast = DynAPI.librarypath+"dynapi/images/explorer/nimasnimenos_u.gif"
leave.style_link = "linkS"
leave.style_home = "homeS"
leave.style_current = "currentS"

// Tree setup
explorer.homeLink = "home.html"
explorer.homeText = "Ein ?"

